/*
 * Decompiled with CFR 0.152.
 */
package jgamebase.db.filter;

import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.util.ImportFilter;
import java.io.IOException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;

public class TextNotNull_ImportFilter
implements ImportFilter {
    private final String defaultValue;
    private final int[] columnsToConvert;

    public TextNotNull_ImportFilter(String defaultValue, int ... columnsToConvert) {
        this.defaultValue = defaultValue;
        this.columnsToConvert = columnsToConvert;
    }

    public List<ColumnBuilder> filterColumns(List<ColumnBuilder> destColumns, ResultSetMetaData srcColumns) throws SQLException, IOException {
        int[] nArray = this.columnsToConvert;
        int n = this.columnsToConvert.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            ColumnBuilder column = destColumns.get(element);
            if (column.getType() != DataType.TEXT) {
                throw new RuntimeException("Column " + column.getName() + " has data type " + column.getType() + " (should be TEXT)!");
            }
            destColumns.set(element, column);
            ++n2;
        }
        return destColumns;
    }

    public Object[] filterRow(Object[] row) throws SQLException, IOException {
        int[] nArray = this.columnsToConvert;
        int n = this.columnsToConvert.length;
        int n2 = 0;
        while (n2 < n) {
            int columnToConvert = nArray[n2];
            if (row[columnToConvert] == null) {
                row[columnToConvert] = this.defaultValue;
            }
            ++n2;
        }
        return row;
    }
}

